function [dataout, residue] = find_sparse(datain, N1, N2, iterations, test_mode)
% pocs lasso solver using fidelity + soft thresholding for sparse solution.
% test mode = 1 is to test known data by removing N1, N2 points.
% ifftc, fftc centered Fourier transform.
% ========================================================================

if nargin < 5
    test_mode = 0;
end

if test_mode > 0
    dataout = [zeros(N1, 1) ; datain(N1 + 1:end - N2) ; zeros(N2, 1)];
else
    dataout = [zeros(N1, 1) ; datain ; zeros(N2, 1)];
end
residue = zeros(1, iterations);
for j = 1:iterations
    F_1 = ifftc(dataout);
    if j == 1
        lambda = 2e-2*max(abs(F_1));
        %                 lambda = 5e-2*max(abs(F_1));
    end
    F_2 = SoftThresh(F_1, lambda);       % soft threshold.
    dataout = fftc(F_2);

    % fidelity term. Replace with sampled points.
    if test_mode > 0
        residue(j) = norm(datain(:) - dataout(:));
        dataout(N1 + 1:end - N2) = datain(N1 + 1:end - N2);
    else
        dataout(N1 + 1:end - N2) = datain;
        residue(j) = mean(abs(F_1));
    end
end
